/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.DoubleMath;

public class Vector {
    private static int x = 0;
    private static int y = 1;
    private static int z = 2;
    public double[] data;
    public final int length;
    private double magnitude;
    private boolean magChanged;

    public Vector(double ... input) {
        this.length = input.length;
        this.data = new double[this.length];
        int i = 0;
        double[] dArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            double val;
            this.data[i] = val = dArray[n2];
            ++i;
            ++n2;
        }
        this.magChanged = true;
    }

    public Vector add(Vector input) {
        Vector output = new Vector(this.data);
        double[] input_data = input.getData();
        double[] output_data = output.getData();
        int i = 0;
        double[] dArray = input_data;
        int n = input_data.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            int n3 = i++;
            output_data[n3] = output_data[n3] + val;
            ++n2;
        }
        return output;
    }

    public Vector sub(Vector input) {
        Vector output = new Vector(this.data);
        double[] input_data = input.getData();
        double[] output_data = output.getData();
        int i = 0;
        double[] dArray = input_data;
        int n = input_data.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            int n3 = i++;
            output_data[n3] = output_data[n3] - val;
            ++n2;
        }
        return output;
    }

    public double dot(Vector input) {
        double output = 0.0;
        int i = 0;
        double[] dArray = input.getData();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double j = dArray[n2];
            output += this.data[i] * j;
            ++i;
            ++n2;
        }
        return output;
    }

    public Vector mult(double input) {
        Vector output = new Vector(this.data);
        double[] output_data = output.getData();
        int i = 0;
        while (i < this.length) {
            if (output_data[i] != 0.0) {
                int n = i;
                output_data[n] = output_data[n] * input;
            }
            ++i;
        }
        output.magnitude = this.mag() * input;
        output.magChanged = false;
        return output;
    }

    public Vector div(double input) {
        Vector output = new Vector(this.data);
        double[] output_data = output.getData();
        int i = 0;
        while (i < this.length) {
            int n = i++;
            output_data[n] = output_data[n] / input;
        }
        output.magnitude = this.mag() / input;
        output.magChanged = false;
        return output;
    }

    public double div(Vector input) {
        int i = 0;
        while (i < this.length) {
            double num = this.data[i];
            double denom = input.data[i];
            if (num != 0.0 && denom != 0.0) {
                return num / denom;
            }
            ++i;
        }
        return 0.0;
    }

    public Vector cross(Vector o) {
        if (this.length > 3 || o.length > 3) {
            throw new Error("Vector: Cross Product requires vectors of length 3!");
        }
        double[] output_data = new double[3];
        if (this.length == 2 && o.length == 2) {
            output_data[Vector.x] = 0.0;
            output_data[Vector.y] = 0.0;
            output_data[2] = this.data[x] * o.data[y] - this.data[y] * o.data[x];
            return new Vector(output_data);
        }
        output_data[Vector.x] = this.data[y] * o.data[z] - this.data[z] * o.data[y];
        output_data[Vector.y] = this.data[z] * o.data[x] - this.data[x] * o.data[z];
        output_data[Vector.z] = this.data[x] * o.data[y] - this.data[y] * o.data[x];
        return new Vector(output_data);
    }

    private double[] getData() {
        return this.data;
    }

    public double get(int i) {
        return this.data[i];
    }

    public double getX() {
        return this.data[x];
    }

    public double getY() {
        return this.data[y];
    }

    public double getZ() {
        return this.data[z];
    }

    public double mag() {
        if (this.magChanged) {
            this.magnitude = Math.sqrt(this.dot(this));
            this.magChanged = false;
        }
        return this.magnitude;
    }

    public double sqr_mag() {
        if (this.magChanged) {
            return this.dot(this);
        }
        return this.magnitude * this.magnitude;
    }

    public Vector norm() {
        if (!this.magChanged && this.magnitude == 1.0) {
            return this;
        }
        Vector out = this.div(this.mag());
        out.magnitude = 1.0;
        return out;
    }

    public Vector reflection(Vector normal) {
        return this.sub(normal.mult(2.0).mult(this.dot(normal)));
    }

    public void setMagnitude(double m) {
        this.magChanged = false;
        this.magnitude = m;
    }

    public Vector proj(Vector b) {
        return b.mult(this.dot(b) / b.mag());
    }

    public Vector perp2d() {
        if (this.length != 2) {
            throw new Error("perp2d only workds for 2 dimensional vectors.");
        }
        return new Vector(-this.get(y), this.get(x));
    }

    public boolean equals(Vector input) {
        double[] input_data = input.getData();
        int i = 0;
        while (i < this.length) {
            if (input_data[i] != this.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String output = "(";
        output = String.valueOf(output) + this.data[0];
        int i = 1;
        while (i < this.length) {
            output = String.valueOf(output) + ", " + this.data[i];
            ++i;
        }
        output = String.valueOf(output) + ")";
        return output;
    }

    public Vector clone() {
        return new Vector(this.data);
    }

    public static Vector randV(int start1, int end1, int start2, int end2) {
        int len1 = end1 - start1;
        int len2 = end2 - start2;
        return new Vector((double)len1 * Math.random() + (double)start1, (double)len2 * Math.random() + (double)start2);
    }

    public Vector getPerp() {
        if (this.length != 2) {
            throw new Error("This function only applies to 2 Dimensional vectors.");
        }
        return new Vector(-this.data[1], this.data[0]);
    }

    public boolean isZero() {
        double[] dArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d != 0.0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Vector zero(int size) {
        double[] data = new double[size];
        int i = 0;
        while (i < size) {
            data[i] = 0.0;
            ++i;
        }
        return new Vector(data);
    }

    public static Vector average(Vector ... input) {
        if (input.length == 0) {
            throw new Error("ERROR : Cannot tell what the dimension is with no input vectors");
        }
        Vector output = Vector.zero(input[0].length);
        Vector[] vectorArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            Vector v = vectorArray[n2];
            output = output.add(v);
            ++n2;
        }
        return output.div(input.length);
    }

    public static Vector v(double ... input) {
        return new Vector(input);
    }

    public static Vector v_dir(double angle) {
        return Vector.v(Math.cos(Math.toRadians(angle)), -Math.sin(Math.toRadians(angle)));
    }
}

